<?php

namespace App\Http\Controllers\Admin;

use App\CentralLogics\Helpers;
use App\Http\Controllers\Controller;
use App\Models\Product;
use App\Models\Review;
use Illuminate\Contracts\Foundation\Application;
use Illuminate\Contracts\View\Factory;
use Illuminate\Contracts\View\View;
use Illuminate\Http\JsonResponse;
use Illuminate\Http\Request;

class ReviewsController extends Controller
{
    public function __construct(
        private Product $product,
        private Review $review
    ){}

    /**
     * @param Request $request
     * @return Application|Factory|View
     */
    public function list(Request $request): View|Factory|Application
    {
        $perPage = (int) $request->query('per_page', Helpers::getPagination());
        $queryParams = ['per_page' => $perPage];

        $search = $request->query('search');

        $reviews = $this->review
            ->with(['product', 'customer'])
            ->when($search, function ($query) use (&$queryParams, $search) {
                $queryParams['search'] = $search;
                $query->where(function ($q) use ($search) {
                    $q->whereHas('product', function ($productQuery) use ($search) {
                        $productQuery->where('id', 'like', "%{$search}%")
                            ->orWhere('name', 'like', "%{$search}%");
                    })

                        // OR search in customer (concatenated full name)
                        ->orWhereHas('customer', function ($customerQuery) use ($search) {
                            $customerQuery->whereRaw(
                                "CONCAT(f_name, ' ', l_name) LIKE ?",
                                ["%{$search}%"]
                            );
                        });
                });

            })
            ->latest()
            ->paginate($perPage)
            ->appends($queryParams);

        return view('admin-views.reviews.list', compact('reviews', 'search', 'perPage'));
    }

}
