<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::table('delivery_men', function (Blueprint $table) {
            $table->unsignedTinyInteger('is_active')->default(1)->after('image');
            $table->timestamp('approved_at')->nullable()->after('updated_at');
        });

        DB::table('delivery_men')
            ->select('created_at', 'approved_at')
            ->whereNull('approved_at')
            ->update(['approved_at' => DB::raw('created_at')]);
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::table('delivery_men', function (Blueprint $table) {
            $table->dropColumn(['is_active', 'approved_at']);
        });
    }
};
