<?php

use App\Models\Product;
use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::table('products', function (Blueprint $table) {
            $table->decimal('min_price', 10, 2)->nullable()->index();
        });

        Product::chunk(100, function ($products) {
            foreach ($products as $product) {
                $variations = json_decode($product->variations, true);
                $minVariation = collect($variations)->pluck('price')->min();
                $product->min_price = round($minVariation ?? $product->price, 2);

                $product->save();
            }
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::table('products', function (Blueprint $table) {
            $table->dropColumn('min_price');
        });
    }
};
