'use strict'
$(window).on('load', () => {
    initEmojiPicker();
});

function initEmojiPicker() {
    const trigger = document.getElementById('trigger');
    const inputField = document.getElementById('msgInputValue');

    // if elements are missing, skip
    if (!trigger || !inputField) return;

    const { createPopup } = window.picmoPopup;

    const picker = createPopup(
        {},
        {
            referenceElement: trigger,
            triggerElement: trigger,
            position: "right-end",
        }
    );

    trigger.addEventListener('click', () => {
        picker.toggle();
    });

    picker.addEventListener('emoji:select', (selection) => {
        const { emoji } = selection;

        const startPos = inputField.selectionStart;
        const endPos = inputField.selectionEnd;
        const value = inputField.value;

        inputField.value = value.substring(0, startPos) + emoji + value.substring(endPos);
        inputField.selectionStart = inputField.selectionEnd = startPos + emoji.length;
        inputField.focus();
    });
}
