@php use App\CentralLogics\Helpers; @endphp
@extends('layouts.admin.app')

@section('title', translate('Deliveryman List'))

@section('content')
    <div class="content container-fluid">
        <h4 class="text-capitalize mb-3 d-flex align-items-center gap-2">
            <img width="20" src="{{asset('public/assets/admin/img/icons/deliveryman-new.png')}}"
                 alt="{{ translate('deliveryman') }}">
            {{translate('deliveryman_list')}}
        </h4>

        <div class="card card-body mb-4">
            <form action="" method="GET">
                <div class="row g-2 align-items-end">
                    <div class="col-md-6 col-xxl-3">
                        <div>
                            <label class="input-label" for="">{{ translate('Deliveryman Joining Date') }}</label>
                            <div class="position-relative">
                                <i class="tio-calendar icon-absolute-on-right"></i>
                                <input type="text" name="joining_date" value="{{ request()->get('joining_date') }}"
                                       class="form-control js-daterangepicker-formatted"
                                       placeholder="{{ translate('Select Date') }}">
                            </div>
                        </div>
                    </div>
                    <div class="col-md-6 col-xxl-3">
                        <div>
                            <label class="input-label" for="">{{ translate('Sort') }}</label>
                            <select name="sort" id="" class="form-control custom-select">
                                <option
                                    value="completed_order" {{ request()->get('sort') == 'completed_order' ? 'selected' : '' }}>{{ translate('Sort By Completed Order') }}</option>
                                <option
                                    value="assigned_orders" {{ request()->get('sort') == 'assigned_orders' ? 'selected' : '' }}>{{ translate('Sort By Assigned Orders') }}</option>
                                <option
                                    value="newly_joined" {{ request()->get('sort') == 'newly_joined' ? 'selected' : '' }}>{{ translate('Sort By Newly Joined Deliveryman') }}</option>
                            </select>
                        </div>
                    </div>
                    <div class="col-md-6 col-xxl-3">
                        <div>
                            <label class="input-label" for="">{{ translate('Deliveryman Status') }}</label>
                            <select name="status" id="" class="form-control custom-select">
                                <option value="all">{{ translate('All') }}</option>
                                <option
                                    value="1" {{ request()->get('status') == '1' ? 'selected' : '' }}>{{ translate('Active') }}</option>
                                <option
                                    value="0" {{ request()->get('status') == '0' ? 'selected' : '' }}>{{ translate('Inactive') }}</option>
                            </select>
                        </div>
                    </div>
                    <div class="col-md-6 col-xxl-3">
                        <div class="d-flex justify-content-end align-items-center gap-2">
                            <a href="{{ route('admin.delivery-man.list') }}"
                               class="btn min-w-120 btn-secondary">{{ translate('Reset') }}</a>
                            <button type="submit" class="btn min-w-120 btn-primary">{{ translate('Filter') }}</button>
                        </div>
                    </div>
                    <input type="hidden" name="search" value="{{ request()->get('search') }}">
                </div>
            </form>
        </div>

        <div class="row gx-3 gy-2 mb-3">
            <div class="col-md-6 col-lg-4">
                <a href="#">
                    <div
                        class="badge-soft-info text-dark border rounded-lg p-3 p-lg-4 d-flex justify-content-between gap-2 overflow-wrap-anywhere h-100">
                        <div>
                            <h2 class="fs-16-mobile mb-1 text-link">{{ $totalDeliveryMen }}</h2>
                            <h5 class="mb-0">{{translate('Total Deliveryman')}}</h5>
                        </div>
                        <div>
                            <img width="38" class="img-fluid"
                                 src="{{asset('public/assets/admin/img/icons/deliveryman-lg.png')}}"
                                 alt="{{ translate('deliveryman') }}">
                        </div>
                    </div>
                </a>
            </div>
            <div class="col-md-6 col-lg-4">
                <a href="#">
                    <div
                        class="badge-soft-success text-dark border rounded-lg p-3 p-lg-4 d-flex justify-content-between gap-2 overflow-wrap-anywhere h-100">
                        <div>
                            <h2 class="fs-16-mobile mb-1 text-success">{{ $activeDeliveryMen }}</h2>
                            <h5 class="mb-0">{{translate('Active Deliveryman')}}</h5>
                        </div>
                        <img width="38" class="avatar avatar-40"
                             src="{{asset('public/assets/admin/img/icons/deliveryman-active.png')}}"
                             alt="{{ translate('deliveryman') }}">
                    </div>
                </a>
            </div>
            <div class="col-md-6 col-lg-4">
                <a href="#">
                    <div
                        class="badge-soft-danger text-dark border rounded-lg p-3 p-lg-4 d-flex justify-content-between gap-2 overflow-wrap-anywhere h-100">
                        <div>
                            <h2 class="fs-16-mobile mb-1 text-danger">{{ $inactiveDeliveryMen }}</h2>
                            <h5 class="mb-0">{{translate('Inactive Deliveryman')}}</h5>
                        </div>
                        <img width="38" class="avatar avatar-40"
                             src="{{asset('public/assets/admin/img/icons/deliveryman-inactive.png')}}"
                             alt="{{ translate('deliveryman') }}">
                    </div>
                </a>
            </div>
        </div>

        <div class="card">

            <div class="p-3">
                <div class="d-flex flex-wrap justify-content-between align-items-center gap-3">
                    <div class="d-flex flex-wrap gap-2 align-items-center">
                        <h5 class="text-capitalize mb-0">
                            {{translate('deliveryman_List')}}
                        </h5>
                        <span class="badge badge-soft-dark rounded-50 fs-14">{{ $deliveryMenList->total() }}</span>
                    </div>
                    <div class="d-flex flex-wrap align-items-center gap-3 flex-grow-1 justify-content-md-end">
                        <form action="{{ request()->url() }}" method="GET" class="flex-grow-1 max-w-270">
                            @foreach (request()->except('search','page') as $key => $value)
                                <input type="hidden" name="{{ $key }}" value="{{ $value }}">
                            @endforeach
                            <div class="input-group min-h-35 w-100">
                                <input id="datatableSearch_" type="search" name="search"
                                       class="form-control py-1 h-35 fs-12"
                                       placeholder="{{translate('Search by name.....')}}" aria-label="Search"
                                       value="{{ request()->get('search') }}" autocomplete="off">
                                <div class="input-group-append">
                                    <button type="submit" class="btn btn-primary px-2 py-1 min-h-35">
                                        <i class="tio-search"></i>
                                    </button>
                                </div>
                            </div>
                        </form>
                        <div>
                            <button type="button"
                                    class="btn btn-outline-primary gap-1 d-flex font-weight-bold align-items-center min-h-35 py-1 fs-12 cmn-border"
                                    data-toggle="dropdown" aria-expanded="false">
                                <i class="tio-download-to"></i>{{ translate('export') }}<i class="tio-chevron-down"></i>
                            </button>
                            <ul class="dropdown-menu dropdown-menu-right w-auto">
                                <li>
                                    <a type="submit" class="dropdown-item d-flex align-items-center gap-2"
                                       href="{{ route('admin.delivery-man.export', request()->query()) }}">
                                        <img width="14" src="{{asset('public/assets/admin/img/icons/excel.png')}}"
                                             alt="{{ translate('excel') }}">
                                        {{translate('excel')}}
                                    </a>
                                </li>
                            </ul>
                        </div>
                        <a href="{{route('admin.delivery-man.add')}}"
                           class="btn btn-primary gap-1 d-flex font-weight-bold align-items-center min-h-35 py-1 fs-12 cmn-border">
                            <i class="tio-add-circle"></i>
                            {{translate('add_deliveryman')}}
                        </a>
                    </div>
                </div>
            </div>

            <div class="table-responsive datatable-custom">
                <table
                    class="table table-border table-thead-bordered table-nowrap table-align-middle card-table text-dark">
                    <thead class="thead-light">
                    <tr>
                        <th>{{translate('SL')}}</th>
                        <th>{{translate('name')}}</th>
                        <th>{{translate('contact_Info')}}</th>
                        <th class="text-center">{{translate('Completed Order')}}</th>
                        <th class="text-center">{{translate('Assigned Orders')}}</th>
                        <th class="text-center">{{translate('Out for Delivery')}}</th>
                        <th class="text-center">{{translate('Status')}}</th>
                        <th class="text-center">{{translate('action')}}</th>
                    </tr>
                    </thead>

                    <tbody id="set-rows">
                    @foreach($deliveryMenList as $key=> $deliveryMan)
                        <tr>
                            <td>{{ $deliveryMenList->firstitem() + $key }}</td>
                            <td>
                                <a href="{{ route('admin.delivery-man.details', $deliveryMan->id) }}" class="media gap-3 align-items-center text-dark">
                                    <div class="avatar rounded-circle">
                                        <img class="img-fit rounded-circle"
                                             src="{{ $deliveryMan['image_fullpath'] }}" alt="{{translate('image')}}">
                                    </div>
                                    <div
                                        class="media-body">{{ $deliveryMan['f_name'] . ' ' . $deliveryMan['l_name'] }}</div>
                                </a>
                            </td>
                            <td>
                                <div><a class="text-dark"
                                        href="tel:{{ $deliveryMan['phone'] }}">{{ $deliveryMan['phone'] }}</a></div>
                                <div><a class="text-dark"
                                        href="mailto:{{ $deliveryMan['email'] }}">{{ $deliveryMan['email'] }}</a></div>
                            </td>
                            <td class="text-center">{{ $deliveryMan->orders->where('order_status', 'delivered')->count() }}</td>
                            <td class="text-center">{{ $deliveryMan->orders->where('order_status', 'processing')->count() }}</td>
                            <td class="text-center">{{ $deliveryMan->orders->where('order_status', 'out_for_delivery')->count() }}</td>
                            <td>
                                <div class="d-flex justify-content-center align-items-center">
                                    <label class="switcher">
                                        <input type="checkbox" class="switcher_input route-alert"
                                               data-route="{{ route('admin.delivery-man.status', [$deliveryMan->id, $deliveryMan->is_active ? 0 : 1]) }}"
                                               data-message="{{ $deliveryMan->is_active? translate('you_want_to_disable_this'): translate('you_want_to_active_this') }}"
                                            {{ $deliveryMan->is_active ? 'checked' : '' }} >
                                        <span class="switcher_control"></span>
                                    </label>
                                </div>
                            </td>
                            <td>
                                <div class="d-flex justify-content-center align-items-center gap-10">
                                    <a class="btn btn-outline-primary square-btn"
                                       href="{{ route('admin.delivery-man.details', ['id' => $deliveryMan['id']]) }}"><i
                                            class="tio-visible"></i>
                                    </a>
                                    <a class="btn btn-outline--info square-btn"
                                       href="{{route('admin.delivery-man.edit',[$deliveryMan['id']])}}"><i
                                            class="tio-edit"></i></a>
                                    <a class="btn btn-outline-danger square-btn form-alert" href="javascript:"
                                       data-id="delivery-man-{{$deliveryMan['id']}}"
                                       data-message="{{translate('Want to delete this deliveryman ?')}}">
                                        <i class="tio-delete"></i>
                                    </a>
                                </div>
                                <form action="{{route('admin.delivery-man.delete',[$deliveryMan['id']])}}"
                                      method="post" id="delivery-man-{{$deliveryMan['id']}}">
                                    @csrf @method('delete')
                                </form>
                            </td>
                        </tr>
                    @endforeach
                    </tbody>
                </table>
            </div>

            <div class="">
                {!! $deliveryMenList->links('layouts/partials/_pagination', ['perPage' => (int) (request()->get('per_page') ?? Helpers::pagination_limit())]) !!}
            </div>
            @if(count($deliveryMenList)==0)
                <div class="text-center p-4">
                    <img class="mb-3 width-7rem" src="{{asset('public/assets/admin//svg/illustrations/sorry.svg')}}"
                         alt="{{ translate('image') }}">
                    <p class="mb-0">{{ translate('No data to show') }}</p>
                </div>
            @endif
        </div>
    </div>

@endsection

@push('script_2')

@endpush
