@extends('layouts.admin.app')

@section('title', translate('Messages'))

@push('css_or_js')
    <link rel="stylesheet" href="{{asset('/public/assets/admin/css/lightbox.min.css')}}">

    <meta name="csrf-token" content="{{ csrf_token() }}">
@endpush

@section('content')
    <div class="content container-fluid">
        <div class="mb-3">
            <h2 class="text-capitalize mb-0 d-flex align-items-center gap-2">
                <img width="20" src="{{asset('public/assets/admin/img/conversation-list.png')}}"
                     alt="{{ translate('message') }}">
                {{translate('conversation_list')}}
            </h2>
        </div>

        <div class="row gy-4">
            <div class="col-lg-4">
                <div class="card h-100">
                    <div class="card-body px-20" id="conversation_sidebar">
                        <div class="chat_people media gap-3 mb-15">
                            <div class="avatar rounded-circle position-relative">
                                <img class="img-fit rounded-circle"
                                     src="{{auth('admin')->user()->image_fullpath}}"
                                     alt="{{ translate('image') }}">
                                <span class="avatar-status status-sm bg-success"></span>
                            </div>
                            <div class="chat_ib media-body">
                                <h5 class="mb-0">{{auth('admin')->user()->f_name}} {{auth('admin')->user()->l_name}}</h5>
                                <span class="fs-12">{{auth('admin')->user()->phone}}</span>
                            </div>
                        </div>
                        <div class="input-group border rounded mb-3 ps-2">
                            <input type="text" class="cz-filter-search form-control h-35 border-0 pl-2 focus-none"
                                   placeholder="{{ translate('Search_user') }}" aria-label="Username"
                                   aria-describedby="basic-addon1" id="search-conversation-user" autocomplete="off">
                            <div class="bg-color-common d-center h-35px input-group-prepend rounded w-35">
                                <span class="border-0 input-group-text p-0 pr-0" id="basic-addon1">
                                    <i class="tio tio-search fs-16"></i>
                                </span>
                            </div>
                        </div>
                        <h4 class="fs-14 mb-10px">{{translate('Customer')}}</h4>
                        <div class="customer-list-wrap">
                            @include('admin-views.messages.partials._customer-list')
                        </div>
                    </div>
                </div>
            </div>
            <div class="col-lg-8">
                <div class="card h-100 p-12px conversation-box">
                    <!-- Empty estate -->
                    <div class="error-boxes w-100 h-100 pb-10 d-center text-center">
                        <div class="pb-10 mb-4">
                            <img width="49" src="{{asset('public/assets/admin/img/receive-mail.png')}}" alt="{{ translate('message') }}" class="mb-10px filter-grayscale-1">
                            <p class="fs-14 m-0 text-dark">{{translate('Select user to see the conversation')}}</p>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <span
        id="conversation-data-to-js"
        data-get-customer-list-route="{{ route('admin.message.get-customer-list') }}"
        data-on-error-global-message="{{ translate('Something went wrong!') }}"
        data-on-empty-reply-and-image="{{ translate('Either message or Files required') }}"
    ></span>

@endsection

@push('script_2')
    <script src="{{asset('public/assets/admin/js/conversation/conversation.js')}}"></script>
     <script src="{{asset('public/assets/admin/js/select-multiple-image-for-message.js')}}"></script>
    <script src="{{asset('public/assets/admin/js/picmo-emoji.js')}}"></script>
    <script src="{{asset('public/assets/admin/js/emoji.js')}}"></script>
@endpush
