@php
    use Illuminate\Support\Facades\Storage;use Illuminate\Support\Str;use function App\Library\formatCustomDateForConversation;
    $userImage = $user->image_fullpath;
@endphp
<div>
    <div>
        <div class="p-3 bg-section3 rounded-8 mb-10px">
            <div class="media gap-3">
                <div class="avatar rounded-circle">
                    <img class="img-fit rounded-circle"
                         src="{{ $user->image_fullpath }}"
                         alt="{{ translate('image') }}">
                </div>
                <div class="mb-0">
                    <a href="{{ route('admin.customer.view', $user->id) }}" class="fs-14 mb-1 text-dark line--limit-1 h4">{{ $user->f_name . ' ' . $user->l_name }}</a>
                    <div class="fs-12 font-weight-normal">{{ $user->phone }}</div>
                </div>
            </div>
        </div>
        <div class="chat_conversation pb-4 mb-3">
            <div class="row g-1">
                @foreach($userConversation as $key => $conversation)
                        <?php
                        $files = json_decode($conversation->attachment, true) ?? [];
                        ?>
                    <div class="col-12">
                        <div class="mx-auto max-w-200">
                            <p class="mb-0 text-left text-center fs-14">{{ formatCustomDateForConversation($conversation->updated_at) }}</p>
                        </div>
                    </div>
                    @if($conversation->is_reply == 0)
                        <div class="col-xl-8 w-90p">
                            <div class="incoming_msg ml-auto d-flex align-items-end gap-2">
                                <div class="">
                                    <img width="25"
                                         class="avatar-img user-avatar-image border inbox-user-avatar-25 rounded-circle aspect-1"
                                         id="profile_image" src="{{ $userImage }}"
                                         alt="Image Description">
                                </div>
                                <div class="received_msg w-100">
                                    @if(count($files) > 0)
                                        <div class="zip-wrapper d-flex gap-3 align-items-center position-relative">
                                            <!-- Thumbnail images -->
                                            <div class="d-flex gap-2 flex-wrap pt-1 justify-content-start zip-images">
                                                @foreach($files as $fileKey => $file)
                                                        <?php
                                                        $fileName = Str::startsWith($file, ['http://', 'https://'])
                                                            ? basename($file)
                                                            : $file;
                                                        $src = Storage::disk('public')->exists('conversation/' . $fileName) ? asset('storage/app/public/conversation/' . $fileName) : asset('public/assets/admin/img/900x400/img1.jpg')
                                                        ?>
                                                    <div class="position-relative {{ $fileKey >= 4 ? 'd-none' : '' }}">
                                                        <a href="javascript:"
                                                           data-toggle="modal"
                                                           data-target="#imgViewModal-{{ $conversation->id }}"
                                                           class="rounded-10px overflow-hidden"
                                                           data-index="{{ $fileKey }}">
                                                            <img
                                                                src="{{ $src }}"
                                                                alt="conversation files"
                                                                class="img-fit aspect-1 w-60px rounded-10px border"
                                                            />
                                                            @if(count($files) > 4 && $fileKey == 3)
                                                                <div
                                                                    class="rounded-10px overflow-hidden extra-images cursor-pointer">
                                                                        <span class="extra-image-count text-white">
                                                                            + {{ count($files) - 3 }}
                                                                        </span>
                                                                </div>
                                                            @endif
                                                        </a>
                                                    </div>
                                                @endforeach
                                            </div>
                                            <a download href="javascript:"
                                               class="btn btn--download {{ count($files) < 2 ? 'download--single-image' : 'zip-download' }} p-1 icon-btn d-flex justify-content-center align-items-center flex-shrink-0">
                                                <i class="tio-download-to text-primary"></i>
                                            </a>
                                        </div>
                                        <div class="modal fade imgViewModal"
                                             id="imgViewModal-{{ $conversation->id }}"
                                             tabindex="-1"
                                             aria-labelledby="imgViewModal{{$conversation->id}}Label"
                                             role="dialog"
                                             aria-modal="true">
                                            <div class="modal-dialog modal-lg modal-dialog-centered">
                                                <div class="modal-content bg-transparent">
                                                    <div class="modal-body pt-0">
                                                        <div
                                                            class="d-flex justify-content-between align-items-end mb-3">
                                                            <div
                                                                class="show-img-title line--limit-1 fs-14 text-white text-center flex-grow-1"></div>
                                                            <button type="button"
                                                                    class="btn btn-close p-1 border-0"
                                                                    data-dismiss="modal"
                                                                    aria-label="Close">
                                                                <i class="tio-clear"></i>
                                                            </button>
                                                        </div>
                                                        <div class="imgView-slider owl-theme owl-carousel"
                                                             dir="ltr">
                                                            @foreach($files as $file)
                                                                    <?php
                                                                    $fileName = Str::startsWith($file, ['http://', 'https://'])
                                                                        ? basename($file)
                                                                        : $file;
                                                                    $src = Storage::disk('public')->exists('conversation/' . $fileName) ? asset('storage/app/public/conversation/' . $fileName) : asset('public/assets/admin/img/900x400/img1.jpg')
                                                                    ?>
                                                                <div class="imgView-item rounded-10px">
                                                                    <div class="thumb">
                                                                        <img class="rounded-10px"
                                                                             src="{{ $src }}" alt="image"
                                                                             data-name="{{ $fileName }}">
                                                                    </div>
                                                                </div>
                                                            @endforeach
                                                        </div>
                                                        @if(count($files) != 1)
                                                            <div
                                                                class="imgView-counter text-white mt-4 pt-lg-3 text-center">
                                                                <span class="current">1</span>/<span
                                                                    class="total">1</span>
                                                            </div>
                                                            <div
                                                                class="imgView-slider_buttons d-flex justify-content-center"
                                                                dir="ltr">
                                                                <button type="button"
                                                                        class="btn owl-btn imgView-owl-prev">
                                                                    <i class="tio-chevron-left"></i>
                                                                </button>
                                                                <button type="button"
                                                                        class="btn owl-btn imgView-owl-next">
                                                                    <i class="tio-chevron-right"></i>
                                                                </button>
                                                            </div>
                                                        @endif
                                                    </div>
                                                </div>
                                            </div>
                                        </div>
                                    @endif
                                    @if($conversation->message)
                                        <div class="message-text-section d-inline-block mt-10px">
                                            <p class="m-0 pb-1 fs-14 text-dark">
                                                {{ $conversation->message }}
                                            </p>
                                        </div>
                                    @endif
                                </div>
                            </div>
                        </div>
                    @else
                        <div class="col-12 w-90p ml-auto">
                            <div class="row justify-content-end">
                                <div class="col-xl-8">
                                    <div class="outgoing_msg w-100 d-flex justify-content-end align-items-end gap-2">
                                        <div class="received_msg w-100 d-flex flex-column align-items-end justify-content-end gap-2">
                                            @if(count($files) > 0)
                                                <div
                                                    class="zip-wrapper d-flex gap-3 align-items-center justify-content-end position-relative">
                                                    <a download href="javascript:"
                                                       class="btn btn--download {{ count($files) > 1 ? 'zip-download' : 'download--single-image' }}  p-1 icon-btn d-flex justify-content-center align-items-center flex-shrink-0">
                                                        <i class="tio-download-to text-primary"></i>
                                                    </a>
                                                    <div
                                                        class="d-flex gap-2 flex-wrap pt-1 justify-content-end zip-images">
                                                        @foreach($files as $fileKey => $file)
                                                                <?php
                                                                $fileName = Str::startsWith($file, ['http://', 'https://'])
                                                                    ? basename($file)
                                                                    : $file;
                                                                $src = Storage::disk('public')->exists('conversation/' . $fileName) ? asset('storage/app/public/conversation/' . $fileName) : asset('public/assets/admin/img/900x400/img1.jpg')
                                                                ?>
                                                            <div class="position-relative {{ $fileKey >= 4 ? 'd-none' : '' }}">
                                                                <a href="javascript:"
                                                                   data-toggle="modal"
                                                                   data-target="#imgViewModal-{{ $conversation->id }}"
                                                                   class="rounded-10px overflow-hidden"
                                                                   data-index="{{ $fileKey }}"
                                                                >
                                                                    <img
                                                                        src="{{ $src }}"
                                                                        alt="conversation files"
                                                                        class="img-fit aspect-1 w-60px rounded-10px border"/>
                                                                    @if(count($files) > 4 && $fileKey == 3)
                                                                        <div
                                                                            class="rounded-10px overflow-hidden extra-images cursor-pointer">
                                                                        <span class="extra-image-count text-white">
                                                                            + {{ count($files) - 3 }}
                                                                        </span>
                                                                        </div>
                                                                    @endif
                                                                </a>
                                                            </div>
                                                        @endforeach
                                                    </div>
                                                </div>
                                                <div class="modal fade imgViewModal"
                                                     id="imgViewModal-{{ $conversation->id }}"
                                                     tabindex="-1"
                                                     aria-labelledby="imgViewModal{{$conversation->id}}Label"
                                                     role="dialog"
                                                     aria-modal="true">
                                                    <div class="modal-dialog modal-lg modal-dialog-centered">
                                                        <div class="modal-content bg-transparent">
                                                            <div class="modal-body pt-0">
                                                                <div
                                                                    class="d-flex justify-content-between align-items-end mb-3">
                                                                    <div
                                                                        class="show-img-title line--limit-1 fs-14 text-white text-center flex-grow-1"></div>
                                                                    <button type="button"
                                                                            class="btn btn-close p-1 border-0"
                                                                            data-dismiss="modal"
                                                                            aria-label="Close">
                                                                        <i class="tio-clear"></i>
                                                                    </button>
                                                                </div>
                                                                <div class="imgView-slider owl-theme owl-carousel"
                                                                     dir="ltr">
                                                                    @foreach($files as $file)
                                                                            <?php
                                                                            $fileName = Str::startsWith($file, ['http://', 'https://'])
                                                                                ? basename($file)
                                                                                : $file;
                                                                            $src = Storage::disk('public')->exists('conversation/' . $fileName) ? asset('storage/app/public/conversation/' . $fileName) : asset('public/assets/admin/img/900x400/img1.jpg')
                                                                            ?>
                                                                        <div class="imgView-item rounded-10px">
                                                                            <div class="thumb">
                                                                                <img class="rounded-10px"
                                                                                     src="{{ $src }}" alt="image"
                                                                                     data-name="{{ $fileName }}">
                                                                            </div>
                                                                        </div>
                                                                    @endforeach
                                                                </div>
                                                                @if(count($files) != 1)
                                                                    <div
                                                                        class="imgView-counter text-white mt-4 pt-lg-3 text-center">
                                                                        <span class="current">1</span>/<span
                                                                            class="total">1</span>
                                                                    </div>
                                                                    <div
                                                                        class="imgView-slider_buttons d-flex justify-content-center"
                                                                        dir="ltr">
                                                                        <button type="button"
                                                                                class="btn owl-btn imgView-owl-prev">
                                                                            <i class="tio-chevron-left"></i>
                                                                        </button>
                                                                        <button type="button"
                                                                                class="btn owl-btn imgView-owl-next">
                                                                            <i class="tio-chevron-right"></i>
                                                                        </button>
                                                                    </div>
                                                                @endif
                                                            </div>
                                                        </div>
                                                    </div>
                                                </div>
                                            @endif
                                            @if($conversation->reply)
                                                <div class="message-text-section d-inline-block">
                                                    <p class="m-0 pb-1 fs-14 text-dark">
                                                        {{ $conversation->reply }}
                                                    </p>
                                                </div>
                                            @endif
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    @endif
                @endforeach
            </div>
        </div>
    </div>
    <!-- New Chatting Option -->
    <div class="type_msg">
        <div class="input_msg_write">
            <form action="javascript:" data-ajax="true" enctype="multipart/form-data" id="reply-form" method="post">
                @csrf
                <div class="position-relative upload-wrap-border overflow-hidden d-flex">
                    <div class="d-flex align-items-center m-0 position-absolute top-9 px-3 gap-2">
                        <label class="mb-0 py-0 cursor-pointer">
                            <svg width="20" height="20" viewBox="0 0 20 20" fill="none"
                                 xmlns="http://www.w3.org/2000/svg">
                                <path
                                    d="M0.580781 17.0093L0.560781 17.0293C0.290781 16.4393 0.120781 15.7693 0.0507812 15.0293C0.120781 15.7593 0.310781 16.4193 0.580781 17.0093Z"
                                    fill="#6A727A"/>
                                <path
                                    d="M7.00109 8.37914C8.31557 8.37914 9.38107 7.31357 9.38107 5.99914C9.38107 4.6847 8.31557 3.61914 7.00109 3.61914C5.68665 3.61914 4.62109 4.6847 4.62109 5.99914C4.62109 7.31357 5.68665 8.37914 7.00109 8.37914Z"
                                    fill="#6A727A"/>
                                <path
                                    d="M14.19 0H5.81C2.17 0 0 2.17 0 5.81V14.19C0 15.28 0.19 16.23 0.56 17.03C1.42 18.93 3.26 20 5.81 20H14.19C17.83 20 20 17.83 20 14.19V11.9V5.81C20 2.17 17.83 0 14.19 0ZM18.37 10.5C17.59 9.83 16.33 9.83 15.55 10.5L11.39 14.07C10.61 14.74 9.35 14.74 8.57 14.07L8.23 13.79C7.52 13.17 6.39 13.11 5.59 13.65L1.85 16.16C1.63 15.6 1.5 14.95 1.5 14.19V5.81C1.5 2.99 2.99 1.5 5.81 1.5H14.19C17.01 1.5 18.5 2.99 18.5 5.81V10.61L18.37 10.5Z"
                                    fill="#6A727A"/>
                            </svg>
                            <input type="file" id="select-media"
                                   name="images[]"
                                   class="h-100 position-absolute w-100 select-media" hidden multiple
                                   accept=".{{ implode(',.', array_column(IMAGE_EXTENSIONS, 'key')) }}"
                                   data-maxFileSize="{{ readableUploadMaxFileSize('image') }}"
                            >
                        </label>
                        <label class="mb-0 py-0 cursor-pointer" id="trigger">
                            <svg width="24" height="24" viewBox="0 0 24 24" fill="none"
                                 xmlns="http://www.w3.org/2000/svg">
                                <g clip-path="url(#clip0_2763_4137)">
                                    <path
                                        d="M12 24C9.62663 24 7.30655 23.2962 5.33316 21.9776C3.35977 20.6591 1.8217 18.7849 0.913451 16.5922C0.00519943 14.3995 -0.232441 11.9867 0.230582 9.65892C0.693605 7.33115 1.83649 5.19295 3.51472 3.51472C5.19295 1.83649 7.33115 0.693605 9.65892 0.230582C11.9867 -0.232441 14.3995 0.00519943 16.5922 0.913451C18.7849 1.8217 20.6591 3.35977 21.9776 5.33316C23.2962 7.30655 24 9.62663 24 12C23.9966 15.1815 22.7312 18.2318 20.4815 20.4815C18.2318 22.7312 15.1815 23.9966 12 24ZM12 2.00001C10.0222 2.00001 8.08879 2.5865 6.4443 3.68531C4.79981 4.78412 3.51809 6.34591 2.76121 8.17317C2.00433 10.0004 1.8063 12.0111 2.19215 13.9509C2.578 15.8907 3.53041 17.6725 4.92894 19.0711C6.32746 20.4696 8.10929 21.422 10.0491 21.8079C11.9889 22.1937 13.9996 21.9957 15.8268 21.2388C17.6541 20.4819 19.2159 19.2002 20.3147 17.5557C21.4135 15.9112 22 13.9778 22 12C21.9971 9.34873 20.9426 6.80689 19.0679 4.93215C17.1931 3.05742 14.6513 2.00292 12 2.00001ZM17.666 15.746C17.8641 15.5696 17.9841 15.3218 17.9994 15.057C18.0148 14.7922 17.9244 14.5321 17.748 14.334C17.5716 14.1359 17.3238 14.0159 17.059 14.0006C16.7942 13.9852 16.5341 14.0756 16.336 14.252C15.1135 15.2813 13.5945 15.8936 12 16C10.4064 15.8937 8.88823 15.2821 7.666 14.254C7.46815 14.0774 7.20824 13.9866 6.94344 14.0016C6.67863 14.0166 6.43064 14.1362 6.254 14.334C6.07737 14.5319 5.98657 14.7918 6.00157 15.0566C6.01657 15.3214 6.13615 15.5694 6.334 15.746C7.92187 17.1025 9.91422 17.8951 12 18C14.0858 17.8951 16.0781 17.1025 17.666 15.746ZM6 10C6 11 6.89501 11 8 11C9.10501 11 10 11 10 10C10 9.46957 9.78929 8.96087 9.41422 8.58579C9.03915 8.21072 8.53044 8 8 8C7.46957 8 6.96086 8.21072 6.58579 8.58579C6.21072 8.96087 6 9.46957 6 10ZM14 10C14 11 14.895 11 16 11C17.105 11 18 11 18 10C18 9.46957 17.7893 8.96087 17.4142 8.58579C17.0391 8.21072 16.5304 8 16 8C15.4696 8 14.9609 8.21072 14.5858 8.58579C14.2107 8.96087 14 9.46957 14 10Z"
                                        fill="#F9BD23"/>
                                </g>
                                <defs>
                                    <clipPath id="clip0_2763_4137">
                                        <rect width="24" height="24" fill="white"/>
                                    </clipPath>
                                </defs>
                            </svg>
                        </label>
                    </div>
                    <label class="w-0 flex-grow-1 uploaded-file-container">
                        <textarea
                            class="form-control pt-11px  resize-none radius-left-button rounded-lg outline-0 shadow-0 focus-0 pl-80px border-0"
                            id="msgInputValue" name="reply" type="text"
                            placeholder="{{translate('Start a new message')}}"
                            data-required-msg="{{ translate('write_something') }}"
                            aria-label="Search" rows="1"></textarea>
                        <div class="multiple-image-upload-error">
                            <div class="d-flex justify-content-between items-container">
                                <div class="overflow-x-auto pt-0 pb-0">
                                    <div>
                                        <div class="d-flex gap-3 image-previw-multiple-here">
                                            <div class="d-flex gap-2 image-array"></div>
                                            <div class="d-flex gap-3 input-uploaded-file"></div>
                                        </div>
                                    </div>
                                    <div id="selected-media-container"></div>
                                </div>
                            </div>
                            <p class="text-danger mb-3 px-3 fs-13 d-none">{{ translate('You can upload a maximum of 4 images at a time.') }}</p>
                        </div>
                    </label>
                    <div
                        class="d-flex align-items-end justify-content-center bg-F1F7FF flex-shrink-0 radius-right-button">
                        <button class="aSend bg-transparent outline-0 border-0 shadow-0 send-btn" type="submit"
                                id="reply-conversation-message"
                                data-route="{{route('admin.message.store', $user->id)}}"
                        >
                            <img src="{{asset('public/assets/admin/img/send-icon.png')}}" alt="">
                        </button>
                    </div>
                </div>
            </form>
        </div>
    </div>
    <!-- New Chatting Option -->
</div>
