<?php
/*
 * Copyright 2014 Google Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not
 * use this file except in compliance with the License. You may obtain a copy of
 * the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 */

namespace Google\Service\Container;

class MaintenancePolicy extends \Google\Model
{
  protected $disruptionBudgetType = DisruptionBudget::class;
  protected $disruptionBudgetDataType = '';
  /**
   * A hash identifying the version of this policy, so that updates to fields of
   * the policy won't accidentally undo intermediate changes (and so that users
   * of the API unaware of some fields won't accidentally remove other fields).
   * Make a `get()` request to the cluster to get the current resource version
   * and include it with requests to set the policy.
   *
   * @var string
   */
  public $resourceVersion;
  protected $windowType = MaintenanceWindow::class;
  protected $windowDataType = '';

  /**
   * Optional. The upgrade disruption budget for the cluster control plane.
   *
   * @param DisruptionBudget $disruptionBudget
   */
  public function setDisruptionBudget(DisruptionBudget $disruptionBudget)
  {
    $this->disruptionBudget = $disruptionBudget;
  }
  /**
   * @return DisruptionBudget
   */
  public function getDisruptionBudget()
  {
    return $this->disruptionBudget;
  }
  /**
   * A hash identifying the version of this policy, so that updates to fields of
   * the policy won't accidentally undo intermediate changes (and so that users
   * of the API unaware of some fields won't accidentally remove other fields).
   * Make a `get()` request to the cluster to get the current resource version
   * and include it with requests to set the policy.
   *
   * @param string $resourceVersion
   */
  public function setResourceVersion($resourceVersion)
  {
    $this->resourceVersion = $resourceVersion;
  }
  /**
   * @return string
   */
  public function getResourceVersion()
  {
    return $this->resourceVersion;
  }
  /**
   * Specifies the maintenance window in which maintenance may be performed.
   *
   * @param MaintenanceWindow $window
   */
  public function setWindow(MaintenanceWindow $window)
  {
    $this->window = $window;
  }
  /**
   * @return MaintenanceWindow
   */
  public function getWindow()
  {
    return $this->window;
  }
}

// Adding a class alias for backwards compatibility with the previous class name.
class_alias(MaintenancePolicy::class, 'Google_Service_Container_MaintenancePolicy');
