<?php
/*
 * Copyright 2014 Google Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not
 * use this file except in compliance with the License. You may obtain a copy of
 * the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 */

namespace Google\Service\Datalineage;

class GoogleCloudDatacatalogLineageConfigmanagementV1ConfigIngestionIngestionRuleIntegrationSelector extends \Google\Model
{
  /**
   * Integration is Unspecified
   */
  public const INTEGRATION_INTEGRATION_UNSPECIFIED = 'INTEGRATION_UNSPECIFIED';
  /**
   * Dataproc
   */
  public const INTEGRATION_DATAPROC = 'DATAPROC';
  /**
   * Required. Integration to which the rule applies. This field can be used to
   * specify the integration against which the ingestion rule should be applied.
   *
   * @var string
   */
  public $integration;

  /**
   * Required. Integration to which the rule applies. This field can be used to
   * specify the integration against which the ingestion rule should be applied.
   *
   * Accepted values: INTEGRATION_UNSPECIFIED, DATAPROC
   *
   * @param self::INTEGRATION_* $integration
   */
  public function setIntegration($integration)
  {
    $this->integration = $integration;
  }
  /**
   * @return self::INTEGRATION_*
   */
  public function getIntegration()
  {
    return $this->integration;
  }
}

// Adding a class alias for backwards compatibility with the previous class name.
class_alias(GoogleCloudDatacatalogLineageConfigmanagementV1ConfigIngestionIngestionRuleIntegrationSelector::class, 'Google_Service_Datalineage_GoogleCloudDatacatalogLineageConfigmanagementV1ConfigIngestionIngestionRuleIntegrationSelector');
