<?php
/*
 * Copyright 2014 Google Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not
 * use this file except in compliance with the License. You may obtain a copy of
 * the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 */

namespace Google\Service\Walletobjects;

class Media extends \Google\Collection
{
  /**
   * Reference contains a GFS path or a local path.
   */
  public const REFERENCE_TYPE_PATH = 'PATH';
  /**
   * Reference points to a blobstore object. This could be either a v1 blob_ref
   * or a v2 blobstore2_info. Clients should check blobstore2_info first, since
   * v1 is being deprecated.
   */
  public const REFERENCE_TYPE_BLOB_REF = 'BLOB_REF';
  /**
   * Data is included into this proto buffer
   */
  public const REFERENCE_TYPE_INLINE = 'INLINE';
  /**
   * Data should be accessed from the current service using the operation
   * GetMedia.
   */
  public const REFERENCE_TYPE_GET_MEDIA = 'GET_MEDIA';
  /**
   * The content for this media object is stored across multiple partial media
   * objects under the composite_media field.
   */
  public const REFERENCE_TYPE_COMPOSITE_MEDIA = 'COMPOSITE_MEDIA';
  /**
   * Reference points to a bigstore object
   */
  public const REFERENCE_TYPE_BIGSTORE_REF = 'BIGSTORE_REF';
  /**
   * Indicates the data is stored in diff_version_response.
   */
  public const REFERENCE_TYPE_DIFF_VERSION_RESPONSE = 'DIFF_VERSION_RESPONSE';
  /**
   * Indicates the data is stored in diff_checksums_response.
   */
  public const REFERENCE_TYPE_DIFF_CHECKSUMS_RESPONSE = 'DIFF_CHECKSUMS_RESPONSE';
  /**
   * Indicates the data is stored in diff_download_response.
   */
  public const REFERENCE_TYPE_DIFF_DOWNLOAD_RESPONSE = 'DIFF_DOWNLOAD_RESPONSE';
  /**
   * Indicates the data is stored in diff_upload_request.
   */
  public const REFERENCE_TYPE_DIFF_UPLOAD_REQUEST = 'DIFF_UPLOAD_REQUEST';
  /**
   * Indicates the data is stored in diff_upload_response.
   */
  public const REFERENCE_TYPE_DIFF_UPLOAD_RESPONSE = 'DIFF_UPLOAD_RESPONSE';
  /**
   * Indicates the data is stored in cosmo_binary_reference.
   */
  public const REFERENCE_TYPE_COSMO_BINARY_REFERENCE = 'COSMO_BINARY_REFERENCE';
  /**
   * Informs Scotty to generate a response payload with the size specified in
   * the length field. The contents of the payload are generated by Scotty and
   * are undefined. This is useful for testing download speeds between the user
   * and Scotty without involving a real payload source. Note: range is not
   * supported when using arbitrary_bytes.
   */
  public const REFERENCE_TYPE_ARBITRARY_BYTES = 'ARBITRARY_BYTES';
  protected $collection_key = 'compositeMedia';
  /**
   * Deprecated, use one of explicit hash type fields instead. Algorithm used
   * for calculating the hash. As of 2011/01/21, "MD5" is the only possible
   * value for this field. New values may be added at any time.
   *
   * @deprecated
   * @var string
   */
  public $algorithm;
  /**
   * Use object_id instead.
   *
   * @deprecated
   * @var string
   */
  public $bigstoreObjectRef;
  /**
   * Blobstore v1 reference, set if reference_type is BLOBSTORE_REF This should
   * be the byte representation of a blobstore.BlobRef. Since Blobstore is
   * deprecating v1, use blobstore2_info instead. For now, any v2 blob will also
   * be represented in this field as v1 BlobRef.
   *
   * @deprecated
   * @var string
   */
  public $blobRef;
  protected $blobstore2InfoType = Blobstore2Info::class;
  protected $blobstore2InfoDataType = '';
  protected $compositeMediaType = CompositeMedia::class;
  protected $compositeMediaDataType = 'array';
  /**
   * MIME type of the data
   *
   * @var string
   */
  public $contentType;
  protected $contentTypeInfoType = ContentTypeInfo::class;
  protected $contentTypeInfoDataType = '';
  /**
   * A binary data reference for a media download. Serves as a technology-
   * agnostic binary reference in some Google infrastructure. This value is a
   * serialized storage_cosmo.BinaryReference proto. Storing it as bytes is a
   * hack to get around the fact that the cosmo proto (as well as others it
   * includes) doesn't support JavaScript. This prevents us from including the
   * actual type of this field.
   *
   * @var string
   */
  public $cosmoBinaryReference;
  /**
   * For Scotty Uploads: Scotty-provided hashes for uploads For Scotty
   * Downloads: (WARNING: DO NOT USE WITHOUT PERMISSION FROM THE SCOTTY TEAM.) A
   * Hash provided by the agent to be used to verify the data being downloaded.
   * Currently only supported for inline payloads. Further, only crc32c_hash is
   * currently supported.
   *
   * @var string
   */
  public $crc32cHash;
  protected $diffChecksumsResponseType = DiffChecksumsResponse::class;
  protected $diffChecksumsResponseDataType = '';
  protected $diffDownloadResponseType = DiffDownloadResponse::class;
  protected $diffDownloadResponseDataType = '';
  protected $diffUploadRequestType = DiffUploadRequest::class;
  protected $diffUploadRequestDataType = '';
  protected $diffUploadResponseType = DiffUploadResponse::class;
  protected $diffUploadResponseDataType = '';
  protected $diffVersionResponseType = DiffVersionResponse::class;
  protected $diffVersionResponseDataType = '';
  protected $downloadParametersType = DownloadParameters::class;
  protected $downloadParametersDataType = '';
  /**
   * Original file name
   *
   * @var string
   */
  public $filename;
  /**
   * Deprecated, use one of explicit hash type fields instead. These two hash
   * related fields will only be populated on Scotty based media uploads and
   * will contain the content of the hash group in the NotificationRequest: http
   * ://cs/#google3/blobstore2/api/scotty/service/proto/upload_listener.proto&q=
   * class:Hash Hex encoded hash value of the uploaded media.
   *
   * @deprecated
   * @var string
   */
  public $hash;
  /**
   * For Scotty uploads only. If a user sends a hash code and the backend has
   * requested that Scotty verify the upload against the client hash, Scotty
   * will perform the check on behalf of the backend and will reject it if the
   * hashes don't match. This is set to true if Scotty performed this
   * verification.
   *
   * @var bool
   */
  public $hashVerified;
  /**
   * Media data, set if reference_type is INLINE
   *
   * @var string
   */
  public $inline;
  /**
   * |is_potential_retry| is set false only when Scotty is certain that it has
   * not sent the request before. When a client resumes an upload, this field
   * must be set true in agent calls, because Scotty cannot be certain that it
   * has never sent the request before due to potential failure in the session
   * state persistence.
   *
   * @var bool
   */
  public $isPotentialRetry;
  /**
   * Size of the data, in bytes
   *
   * @var string
   */
  public $length;
  /**
   * Scotty-provided MD5 hash for an upload.
   *
   * @var string
   */
  public $md5Hash;
  /**
   * Media id to forward to the operation GetMedia. Can be set if reference_type
   * is GET_MEDIA.
   *
   * @var string
   */
  public $mediaId;
  protected $objectIdType = ObjectId::class;
  protected $objectIdDataType = '';
  /**
   * Path to the data, set if reference_type is PATH
   *
   * @var string
   */
  public $path;
  /**
   * Describes what the field reference contains.
   *
   * @var string
   */
  public $referenceType;
  /**
   * Scotty-provided SHA1 hash for an upload.
   *
   * @var string
   */
  public $sha1Hash;
  /**
   * Scotty-provided SHA256 hash for an upload.
   *
   * @var string
   */
  public $sha256Hash;
  /**
   * Time at which the media data was last updated, in milliseconds since UNIX
   * epoch
   *
   * @var string
   */
  public $timestamp;
  /**
   * A unique fingerprint/version id for the media data
   *
   * @var string
   */
  public $token;

  /**
   * Deprecated, use one of explicit hash type fields instead. Algorithm used
   * for calculating the hash. As of 2011/01/21, "MD5" is the only possible
   * value for this field. New values may be added at any time.
   *
   * @deprecated
   * @param string $algorithm
   */
  public function setAlgorithm($algorithm)
  {
    $this->algorithm = $algorithm;
  }
  /**
   * @deprecated
   * @return string
   */
  public function getAlgorithm()
  {
    return $this->algorithm;
  }
  /**
   * Use object_id instead.
   *
   * @deprecated
   * @param string $bigstoreObjectRef
   */
  public function setBigstoreObjectRef($bigstoreObjectRef)
  {
    $this->bigstoreObjectRef = $bigstoreObjectRef;
  }
  /**
   * @deprecated
   * @return string
   */
  public function getBigstoreObjectRef()
  {
    return $this->bigstoreObjectRef;
  }
  /**
   * Blobstore v1 reference, set if reference_type is BLOBSTORE_REF This should
   * be the byte representation of a blobstore.BlobRef. Since Blobstore is
   * deprecating v1, use blobstore2_info instead. For now, any v2 blob will also
   * be represented in this field as v1 BlobRef.
   *
   * @deprecated
   * @param string $blobRef
   */
  public function setBlobRef($blobRef)
  {
    $this->blobRef = $blobRef;
  }
  /**
   * @deprecated
   * @return string
   */
  public function getBlobRef()
  {
    return $this->blobRef;
  }
  /**
   * Blobstore v2 info, set if reference_type is BLOBSTORE_REF and it refers to
   * a v2 blob.
   *
   * @param Blobstore2Info $blobstore2Info
   */
  public function setBlobstore2Info(Blobstore2Info $blobstore2Info)
  {
    $this->blobstore2Info = $blobstore2Info;
  }
  /**
   * @return Blobstore2Info
   */
  public function getBlobstore2Info()
  {
    return $this->blobstore2Info;
  }
  /**
   * A composite media composed of one or more media objects, set if
   * reference_type is COMPOSITE_MEDIA. The media length field must be set to
   * the sum of the lengths of all composite media objects. Note: All composite
   * media must have length specified.
   *
   * @param CompositeMedia[] $compositeMedia
   */
  public function setCompositeMedia($compositeMedia)
  {
    $this->compositeMedia = $compositeMedia;
  }
  /**
   * @return CompositeMedia[]
   */
  public function getCompositeMedia()
  {
    return $this->compositeMedia;
  }
  /**
   * MIME type of the data
   *
   * @param string $contentType
   */
  public function setContentType($contentType)
  {
    $this->contentType = $contentType;
  }
  /**
   * @return string
   */
  public function getContentType()
  {
    return $this->contentType;
  }
  /**
   * Extended content type information provided for Scotty uploads.
   *
   * @param ContentTypeInfo $contentTypeInfo
   */
  public function setContentTypeInfo(ContentTypeInfo $contentTypeInfo)
  {
    $this->contentTypeInfo = $contentTypeInfo;
  }
  /**
   * @return ContentTypeInfo
   */
  public function getContentTypeInfo()
  {
    return $this->contentTypeInfo;
  }
  /**
   * A binary data reference for a media download. Serves as a technology-
   * agnostic binary reference in some Google infrastructure. This value is a
   * serialized storage_cosmo.BinaryReference proto. Storing it as bytes is a
   * hack to get around the fact that the cosmo proto (as well as others it
   * includes) doesn't support JavaScript. This prevents us from including the
   * actual type of this field.
   *
   * @param string $cosmoBinaryReference
   */
  public function setCosmoBinaryReference($cosmoBinaryReference)
  {
    $this->cosmoBinaryReference = $cosmoBinaryReference;
  }
  /**
   * @return string
   */
  public function getCosmoBinaryReference()
  {
    return $this->cosmoBinaryReference;
  }
  /**
   * For Scotty Uploads: Scotty-provided hashes for uploads For Scotty
   * Downloads: (WARNING: DO NOT USE WITHOUT PERMISSION FROM THE SCOTTY TEAM.) A
   * Hash provided by the agent to be used to verify the data being downloaded.
   * Currently only supported for inline payloads. Further, only crc32c_hash is
   * currently supported.
   *
   * @param string $crc32cHash
   */
  public function setCrc32cHash($crc32cHash)
  {
    $this->crc32cHash = $crc32cHash;
  }
  /**
   * @return string
   */
  public function getCrc32cHash()
  {
    return $this->crc32cHash;
  }
  /**
   * Set if reference_type is DIFF_CHECKSUMS_RESPONSE.
   *
   * @param DiffChecksumsResponse $diffChecksumsResponse
   */
  public function setDiffChecksumsResponse(DiffChecksumsResponse $diffChecksumsResponse)
  {
    $this->diffChecksumsResponse = $diffChecksumsResponse;
  }
  /**
   * @return DiffChecksumsResponse
   */
  public function getDiffChecksumsResponse()
  {
    return $this->diffChecksumsResponse;
  }
  /**
   * Set if reference_type is DIFF_DOWNLOAD_RESPONSE.
   *
   * @param DiffDownloadResponse $diffDownloadResponse
   */
  public function setDiffDownloadResponse(DiffDownloadResponse $diffDownloadResponse)
  {
    $this->diffDownloadResponse = $diffDownloadResponse;
  }
  /**
   * @return DiffDownloadResponse
   */
  public function getDiffDownloadResponse()
  {
    return $this->diffDownloadResponse;
  }
  /**
   * Set if reference_type is DIFF_UPLOAD_REQUEST.
   *
   * @param DiffUploadRequest $diffUploadRequest
   */
  public function setDiffUploadRequest(DiffUploadRequest $diffUploadRequest)
  {
    $this->diffUploadRequest = $diffUploadRequest;
  }
  /**
   * @return DiffUploadRequest
   */
  public function getDiffUploadRequest()
  {
    return $this->diffUploadRequest;
  }
  /**
   * Set if reference_type is DIFF_UPLOAD_RESPONSE.
   *
   * @param DiffUploadResponse $diffUploadResponse
   */
  public function setDiffUploadResponse(DiffUploadResponse $diffUploadResponse)
  {
    $this->diffUploadResponse = $diffUploadResponse;
  }
  /**
   * @return DiffUploadResponse
   */
  public function getDiffUploadResponse()
  {
    return $this->diffUploadResponse;
  }
  /**
   * Set if reference_type is DIFF_VERSION_RESPONSE.
   *
   * @param DiffVersionResponse $diffVersionResponse
   */
  public function setDiffVersionResponse(DiffVersionResponse $diffVersionResponse)
  {
    $this->diffVersionResponse = $diffVersionResponse;
  }
  /**
   * @return DiffVersionResponse
   */
  public function getDiffVersionResponse()
  {
    return $this->diffVersionResponse;
  }
  /**
   * Parameters for a media download.
   *
   * @param DownloadParameters $downloadParameters
   */
  public function setDownloadParameters(DownloadParameters $downloadParameters)
  {
    $this->downloadParameters = $downloadParameters;
  }
  /**
   * @return DownloadParameters
   */
  public function getDownloadParameters()
  {
    return $this->downloadParameters;
  }
  /**
   * Original file name
   *
   * @param string $filename
   */
  public function setFilename($filename)
  {
    $this->filename = $filename;
  }
  /**
   * @return string
   */
  public function getFilename()
  {
    return $this->filename;
  }
  /**
   * Deprecated, use one of explicit hash type fields instead. These two hash
   * related fields will only be populated on Scotty based media uploads and
   * will contain the content of the hash group in the NotificationRequest: http
   * ://cs/#google3/blobstore2/api/scotty/service/proto/upload_listener.proto&q=
   * class:Hash Hex encoded hash value of the uploaded media.
   *
   * @deprecated
   * @param string $hash
   */
  public function setHash($hash)
  {
    $this->hash = $hash;
  }
  /**
   * @deprecated
   * @return string
   */
  public function getHash()
  {
    return $this->hash;
  }
  /**
   * For Scotty uploads only. If a user sends a hash code and the backend has
   * requested that Scotty verify the upload against the client hash, Scotty
   * will perform the check on behalf of the backend and will reject it if the
   * hashes don't match. This is set to true if Scotty performed this
   * verification.
   *
   * @param bool $hashVerified
   */
  public function setHashVerified($hashVerified)
  {
    $this->hashVerified = $hashVerified;
  }
  /**
   * @return bool
   */
  public function getHashVerified()
  {
    return $this->hashVerified;
  }
  /**
   * Media data, set if reference_type is INLINE
   *
   * @param string $inline
   */
  public function setInline($inline)
  {
    $this->inline = $inline;
  }
  /**
   * @return string
   */
  public function getInline()
  {
    return $this->inline;
  }
  /**
   * |is_potential_retry| is set false only when Scotty is certain that it has
   * not sent the request before. When a client resumes an upload, this field
   * must be set true in agent calls, because Scotty cannot be certain that it
   * has never sent the request before due to potential failure in the session
   * state persistence.
   *
   * @param bool $isPotentialRetry
   */
  public function setIsPotentialRetry($isPotentialRetry)
  {
    $this->isPotentialRetry = $isPotentialRetry;
  }
  /**
   * @return bool
   */
  public function getIsPotentialRetry()
  {
    return $this->isPotentialRetry;
  }
  /**
   * Size of the data, in bytes
   *
   * @param string $length
   */
  public function setLength($length)
  {
    $this->length = $length;
  }
  /**
   * @return string
   */
  public function getLength()
  {
    return $this->length;
  }
  /**
   * Scotty-provided MD5 hash for an upload.
   *
   * @param string $md5Hash
   */
  public function setMd5Hash($md5Hash)
  {
    $this->md5Hash = $md5Hash;
  }
  /**
   * @return string
   */
  public function getMd5Hash()
  {
    return $this->md5Hash;
  }
  /**
   * Media id to forward to the operation GetMedia. Can be set if reference_type
   * is GET_MEDIA.
   *
   * @param string $mediaId
   */
  public function setMediaId($mediaId)
  {
    $this->mediaId = $mediaId;
  }
  /**
   * @return string
   */
  public function getMediaId()
  {
    return $this->mediaId;
  }
  /**
   * Reference to a TI Blob, set if reference_type is BIGSTORE_REF.
   *
   * @param ObjectId $objectId
   */
  public function setObjectId(ObjectId $objectId)
  {
    $this->objectId = $objectId;
  }
  /**
   * @return ObjectId
   */
  public function getObjectId()
  {
    return $this->objectId;
  }
  /**
   * Path to the data, set if reference_type is PATH
   *
   * @param string $path
   */
  public function setPath($path)
  {
    $this->path = $path;
  }
  /**
   * @return string
   */
  public function getPath()
  {
    return $this->path;
  }
  /**
   * Describes what the field reference contains.
   *
   * Accepted values: PATH, BLOB_REF, INLINE, GET_MEDIA, COMPOSITE_MEDIA,
   * BIGSTORE_REF, DIFF_VERSION_RESPONSE, DIFF_CHECKSUMS_RESPONSE,
   * DIFF_DOWNLOAD_RESPONSE, DIFF_UPLOAD_REQUEST, DIFF_UPLOAD_RESPONSE,
   * COSMO_BINARY_REFERENCE, ARBITRARY_BYTES
   *
   * @param self::REFERENCE_TYPE_* $referenceType
   */
  public function setReferenceType($referenceType)
  {
    $this->referenceType = $referenceType;
  }
  /**
   * @return self::REFERENCE_TYPE_*
   */
  public function getReferenceType()
  {
    return $this->referenceType;
  }
  /**
   * Scotty-provided SHA1 hash for an upload.
   *
   * @param string $sha1Hash
   */
  public function setSha1Hash($sha1Hash)
  {
    $this->sha1Hash = $sha1Hash;
  }
  /**
   * @return string
   */
  public function getSha1Hash()
  {
    return $this->sha1Hash;
  }
  /**
   * Scotty-provided SHA256 hash for an upload.
   *
   * @param string $sha256Hash
   */
  public function setSha256Hash($sha256Hash)
  {
    $this->sha256Hash = $sha256Hash;
  }
  /**
   * @return string
   */
  public function getSha256Hash()
  {
    return $this->sha256Hash;
  }
  /**
   * Time at which the media data was last updated, in milliseconds since UNIX
   * epoch
   *
   * @param string $timestamp
   */
  public function setTimestamp($timestamp)
  {
    $this->timestamp = $timestamp;
  }
  /**
   * @return string
   */
  public function getTimestamp()
  {
    return $this->timestamp;
  }
  /**
   * A unique fingerprint/version id for the media data
   *
   * @param string $token
   */
  public function setToken($token)
  {
    $this->token = $token;
  }
  /**
   * @return string
   */
  public function getToken()
  {
    return $this->token;
  }
}

// Adding a class alias for backwards compatibility with the previous class name.
class_alias(Media::class, 'Google_Service_Walletobjects_Media');
