<?php
/*
 * Copyright 2014 Google Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not
 * use this file except in compliance with the License. You may obtain a copy of
 * the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 */

namespace Google\Service\YouTubeAnalytics;

class ResultTableColumnHeader extends \Google\Model
{
  /**
   * The type of the column (`DIMENSION` or `METRIC`).
   *
   * @var string
   */
  public $columnType;
  /**
   * The type of the data in the column (`STRING`, `INTEGER`, `FLOAT`, etc.).
   *
   * @var string
   */
  public $dataType;
  /**
   * The name of the dimension or metric.
   *
   * @var string
   */
  public $name;

  /**
   * The type of the column (`DIMENSION` or `METRIC`).
   *
   * @param string $columnType
   */
  public function setColumnType($columnType)
  {
    $this->columnType = $columnType;
  }
  /**
   * @return string
   */
  public function getColumnType()
  {
    return $this->columnType;
  }
  /**
   * The type of the data in the column (`STRING`, `INTEGER`, `FLOAT`, etc.).
   *
   * @param string $dataType
   */
  public function setDataType($dataType)
  {
    $this->dataType = $dataType;
  }
  /**
   * @return string
   */
  public function getDataType()
  {
    return $this->dataType;
  }
  /**
   * The name of the dimension or metric.
   *
   * @param string $name
   */
  public function setName($name)
  {
    $this->name = $name;
  }
  /**
   * @return string
   */
  public function getName()
  {
    return $this->name;
  }
}

// Adding a class alias for backwards compatibility with the previous class name.
class_alias(ResultTableColumnHeader::class, 'Google_Service_YouTubeAnalytics_ResultTableColumnHeader');
